//===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmFreeBSDPkgManifest.hh 8434 2016-04-29 01:38:22Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2016
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmFreeBSDPkgManifest.hh
//!  \brief class definitions for FreeBSD +MANIFEST file
//---------------------------------------------------------------------------

#ifndef _DWMFREEBSDPKGMANIFEST_HH_
#define _DWMFREEBSDPKGMANIFEST_HH_

#include <iostream>
#include <string>
#include <vector>

namespace Dwm {

  namespace FreeBSDPkg {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Manifest
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      class Dependency
      {
      public:
        Dependency() = default;
        Dependency(const std::string & name, const std::string & origin,
                   const std::string & version);
        const std::string & Name() const;
        const std::string & Name(const std::string & name);
        const std::string & Version() const;
        const std::string & Version(const std::string & version);
        const std::string & Origin() const;
        const std::string & Origin(const std::string & origin);

        friend std::ostream & operator << (std::ostream & os,
                                           const Dependency & dep);
      private:
        std::string  _name;
        std::string  _version;
        std::string  _origin;
      };

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      class Option
      {
      public:
        const std::string & Name() const;
        const std::string & Name(const std::string & name);
        const std::string & Value() const;
        const std::string & Value(const std::string & value);

        friend std::ostream & operator << (std::ostream & os,
                                           const Option & option);

      private:
        std::string  _name;
        std::string  _value;
      };

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      class File
      {
      public:
        File() = default;
        File(const std::string & path, const std::string sha256 = "",
             const std::string & user = "", const std::string group = "",
             mode_t mode = 0);
        const std::string & Path() const;
        const std::string & Path(const std::string & path);
        const std::string & SHA256() const;
        const std::string & SHA256(const std::string & sha256);
        const std::string & User() const;
        const std::string & User(const std::string & user);
        const std::string & Group() const;
        const std::string & Group(const std::string & group);
        mode_t Mode() const;
        mode_t Mode(mode_t mode);
        
        friend std::ostream & operator << (std::ostream & os,
                                           const File & file);
        
      private:
        std::string  _path;
        std::string  _sha256;
        std::string  _user;
        std::string  _group;
        mode_t       _mode;
      };
      
      const std::string & Name() const;
      const std::string & Name(const std::string & name);
      const std::string & Version() const;
      const std::string & Version(const std::string & version);
      const std::string & Origin() const;
      const std::string & Origin(const std::string & origin);
      const std::string & Comment() const;
      const std::string & Comment(const std::string & comment);
      const std::string & Description() const;
      const std::string & Description(const std::string & description);
      const std::string & Arch() const;
      const std::string & Arch(const std::string & arch);
      const std::string & WWW() const;
      const std::string & WWW(const std::string & www);
      const std::string & Maintainer() const;
      const std::string & Maintainer(const std::string & maintainer);
      const std::string & Prefix() const;
      const std::string & Prefix(const std::string & prefix);
      const std::string & LicenseLogic() const;
      const std::string & LicenseLogic(const std::string & licenseLogic);
      
      const std::vector<std::string> & Categories() const;

      const std::vector<std::string> &
      Categories(const std::vector<std::string> & categories);
      
      const std::vector<std::string> & Licenses() const;

      const std::vector<std::string> &
      Licenses(const std::vector<std::string> & licenses);
      
      size_t Flatsize() const;
      size_t Flatsize(size_t flatsize);
      const std::vector<Dependency> & Dependencies() const;
      std::vector<Dependency> & Dependencies();
      const std::vector<Dependency> &
      Dependencies(const std::vector<Dependency> & dependencies);
      const std::string & Conflict() const;
      const std::string & Conflict(const std::string conflict);
      const std::vector<Option> & Options() const;
      std::vector<Option> & Options();
      const std::vector<File> & Files() const;
      std::vector<File> & Files();
      const std::vector<File> & Files(const std::vector<File> & files);

      const std::string & PostInstall() const;

      const std::string & PostInstall(const std::string & postInstall);

      const std::string & PreInstall() const;

      const std::string & PreInstall(const std::string & preInstall);
      
      const std::string & Install() const;

      const std::string & Install(const std::string & install);

      const std::string & PreDeinstall() const;

      const std::string & PreDeinstall(const std::string & preDeinstall);

      const std::string & PostDeinstall() const;

      const std::string & PostDeinstall(const std::string & postDeinstall);

      const std::string & Deinstall() const;

      const std::string & Deinstall(const std::string & deinstall);

      const std::string & PreUpgrade() const;

      const std::string & PreUpgrade(const std::string & preUpgrade);

      const std::string & PostUpgrade() const;

      const std::string & PostUpgrade(const std::string & postUpgrade);

      const std::string & Upgrade() const;

      const std::string & Upgrade(const std::string & upgrade);
      
      bool Parse(const char *filename);

      std::vector<File> MissingFiles(const std::string & dirName) const;

      friend std::ostream & operator << (std::ostream & os,
                                         const Manifest & manifest);
      
    private:
      std::string               _name;
      std::string               _version;
      std::string               _origin;
      std::string               _comment;
      std::string               _description;
      std::string               _arch;
      std::string               _www;
      std::string               _maintainer;
      std::string               _prefix;
      std::string               _licenseLogic;
      std::vector<std::string>  _categories;
      std::vector<std::string>  _licenses;
      size_t                    _flatsize;
      std::vector<Dependency>   _dependencies;
      std::string               _conflict;
      std::vector<Option>       _options;
      std::vector<File>         _files;
      std::string               _postInstall;
      std::string               _preInstall;
      std::string               _install;
      std::string               _postDeinstall;
      std::string               _preDeinstall;
      std::string               _deinstall;
      std::string               _postUpgrade;
      std::string               _preUpgrade;
      std::string               _upgrade;
    };
    
    
  }  // namespace FreeBSDPkg

}  // namespace Dwm

#endif  // _DWMFREEBSDPKGMANIFEST_HH_
