#!/bin/sh

SHARED_LIB_VERSION="1:11:0"

IsTrunk() {
    echo $1 | egrep '\/trunk\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

IsTag() {
    echo $1 | egrep '\/tags\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

IsBranch() {
    echo $1 | egrep '\/branches\/' > /dev/null
    if [ $? -eq 0 ]; then
	echo 0
    fi
}

GetTagVersion() {
    local ver=`echo "$1" | sed -e 's/.*\/tags\/\([^/]*\)\/.*/\1/'`
    echo "${ver}"
}

GetTrunkVersion() {
    local dir=`echo "$1" | sed -e 's/.*\/\([^/]*\)\/trunk\/.*/\1/'`
    echo "${dir}-0.0.`svnversion . | sed 's/[0-9]*://g'`"
}

GetBranchVersion() {
    local dir=`echo "$1" | sed -e 's/.*\/branches\/\([^/]*\)\/.*/\1/'`
    echo "${dir}-`svnversion .`_branch"
}

GetVersion() {
    if [ $(IsTag "$1") ]; then
	echo $(GetTagVersion "$1")
    else
	if [ $(IsBranch "$1") ]; then
	    echo $(GetBranchVersion "$1")
	else
	    if [ $(IsTrunk "$1") ]; then    
		echo $(GetTrunkVersion "$1")
	    fi
	fi
    fi
}

args=`getopt sv $*`
set -- $args
ver=$(GetVersion "$DwmPath: dwm/libDwm/tags/libDwm-0.6.19/getvers.sh 10194 $")
for i; do
    case "$i" in
	-s)
	    echo ${SHARED_LIB_VERSION}
	    exit 0
	    ;;
	-v)
	    echo ${ver} | cut -d'-' -f2-
	    exit 0
	    break;;
    esac
done
echo $(GetVersion "$DwmPath: dwm/libDwm/tags/libDwm-0.6.19/getvers.sh 10194 $")
