//===========================================================================
// @(#) $Name$
// @(#) $Id: psgr.cc 332 2007-01-03 21:43:19Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2006-2007
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file psgr.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <stdio.h>
  #include <regex.h>
  #include <string.h>
  #include <unistd.h>
}

#include <fstream>
#include <iomanip>
#include <iostream>

#include "DwmCvsTag.hh"
#include "DwmDateTime.hh"
#include "DwmGZIO.hh"
#include "DwmEngFormat.hh"
#include "DwmIO.hh"
#include "DwmProcessTable.hh"
#include "DwmStringUtils.hh"

static const Dwm::CvsTag cvstag("@(#) $Name$ $Id: psgr.cc 332 2007-01-03 21:43:19Z dwm $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void Usage(const char *argv0)
{
  cerr << "usage: " << argv0 << " [-f file] [-w] [regex]" << endl;
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
class StartTimeFormat
{
public:
  StartTimeFormat(const TimeValue & tv)
  {
    TimeValue  now(true);
    DateTime   dt(tv);
    if (now.Secs() - tv.Secs() < (24 * 60 * 60))
      _val = dt.Formatted("%T");
    else if (now.Secs() - tv.Secs() < (7 * 25 * 60 * 60))
      _val = dt.Formatted("%a%H:%M");
    else
      _val = dt.Formatted("%d%b%g");
  }
  
  friend ostream & operator << (ostream & os, const StartTimeFormat & pst);
  
private:
  string  _val;
};

ostream & operator << (ostream & os, const StartTimeFormat & pst)
{
  if (os) {
    os << pst._val;
  }
  return(os);
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  bool    showArgs = false;
  string  filename;
  
  string   regExpStr;
  regex_t  regEx;
  
  int  optChar;
  while ((optChar = getopt(argc, argv, "f:w")) != -1) {
    switch (optChar) {
      case 'f':
        filename = optarg;
        break;
      case 'w':
        showArgs = true;
        break;
      default:
        Usage(argv[0]);
        exit(1);
        break;
    }
  }
  
  if (optind < argc) {
    regExpStr = argv[optind];
    regcomp(&regEx,regExpStr.c_str(),REG_NOSUB|REG_EXTENDED);
  }

  if (! regExpStr.empty()) {
  }
  
  ProcessTable  processTable;

  if (! filename.empty()) {
    if (StringUtils::HasSuffix(filename, ".gz")) {
      gzFile  gzf = gzopen(filename.c_str(), "rb");
      if (gzf) {
        GZIO::Read(gzf, processTable);
        gzclose(gzf);
      }
    }
    else {
      ifstream  is(filename.c_str());
      IO::Read(is, processTable);
    }
  }
  else {
    GetProcessTable(processTable);
  }
  
  ProcessTable::const_iterator  pi;
  for (pi = processTable.begin(); pi != processTable.end(); ++pi) {
    if (regExpStr.empty()
        || (strcmp(pi->second.Command().c_str(),argv[0])
            && (regexec(&regEx,pi->second.Command().c_str(),0,NULL,0) == 0)
            && (getpid() != pi->second.Id()))) {
      cout << setw(8) << pi->second.EffectiveUserName() << " " 
           << setw(6) << pi->second.Id() << " "
           << setw(6) << EngFormat(pi->second.Size()) << " "
           << setw(6) << EngFormat(pi->second.ResidentSetSize()) << " "
           << setw(2) << pi->second.ControllingTty() << " "
           << StartTimeFormat(pi->second.StartTime()) << " "
           << pi->second.Command();
      if (showArgs) {
        if (pi->second.Args().size() > 1) {
          vector<string>::const_iterator  ai = pi->second.Args().begin();
          ++ai;
          for ( ; ai != pi->second.Args().end(); ++ai) {
            cout << " " << *ai;
          }
        }
      }
      
      cout << endl;
    }
  }

  exit(0);
}
