//===========================================================================
// @(#) $DwmPath: dwm/libDwm/tags/libDwm-0.6.11/include/DwmWritable.hh 8401 $
// @(#) $Id: DwmWritable.hh 8401 2016-04-17 06:44:31Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2004-2007
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
//  PURPOSE, OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmWritable.hh
//!  \brief Dwm::Writable pure virtual class definition
//---------------------------------------------------------------------------
#ifndef _DWMWRITABLE_HH_
#define _DWMWRITABLE_HH_

extern "C" {
  #include <sys/types.h>
  #include <inttypes.h>
  #include <stdio.h>
}

#include <iostream>

namespace Dwm {

  //--------------------------------------------------------------------------
  //!  This class defines an interface for classes that can write their
  //!  contents to an ostream, file descriptor or FILE pointer.
  //--------------------------------------------------------------------------
  class Writable
  {
  public:
    //------------------------------------------------------------------------
    //!  Destructor
    //------------------------------------------------------------------------
    virtual ~Writable() { }

    //------------------------------------------------------------------------
    //!  Write to an ostream.  Return the ostream.
    //------------------------------------------------------------------------
    virtual std::ostream & Write(std::ostream & os) const = 0;

    //------------------------------------------------------------------------
    //!  Write to a file descriptor.  Return the number of bytes written
    //!  on success, -1 on failure.
    //------------------------------------------------------------------------
    virtual ssize_t Write(int fd) const = 0;

    //------------------------------------------------------------------------
    //!  Write to a FILE pointer.  Return 1 on success, 0 on failure
    //! (fwrite() semantics).
    //------------------------------------------------------------------------
    virtual size_t Write(FILE *f) const = 0;

    //------------------------------------------------------------------------
    //!  Returns the number of bytes that should be written if one of the
    //!  Write() members is called.
    //------------------------------------------------------------------------
    virtual uint32_t StreamedLength() const = 0;
  };
  
    
}  // namespace Dwm

#endif  // _DWMWRITABLE_HH_

//---------------------------- emacs settings -----------------------------
//  Local Variables:
//  mode: C++/la
//  tab-width: 2
//  indent-tabs-mode: nil
//  c-basic-offset: 2
//  End:
//-------------------------------------------------------------------------
