//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.6/classes/include/DwmDnsRRData.hh 10134 $
// @(#) $Id: DwmDnsRRData.hh 10134 2018-01-27 19:10:45Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRData.hh
//!  \brief Dwm::Dns::RRData class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSRRDATA_HH_
#define _DWMDNSRRDATA_HH_

#include <cstdint>
#include <iostream>

#include "DwmDnsLabelPositions.hh"

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  @defgroup rrdatagroup Resource record data classes
    //!  Classes to encapsulate resource record data.
    //!  Nearly all DNS resource records have associated data (OPT
    //!  'pseudo-records' being a notable exception).  For each type of
    //!  resource record that carries data (RRDATA per RFC1035), we have
    //!  a class that encapsulates the data.  They're all derived from the
    //!  pure virtual base class Dwm::Dns::RRData.  Several of the simple
    //!  resource records ony contain a domain name in their data, so we
    //!  also have a Dwm::Dns::RRDataDomainName class to serve as the base
    //!  class for the data for those types of records.
    //------------------------------------------------------------------------
    
    //------------------------------------------------------------------------
    //!  @ingroup rrdatagroup
    //!  Abstract (pure virtual) base for resource record data classes.
    //------------------------------------------------------------------------
    class RRData
    {
    public:
      virtual uint8_t *Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                              LabelPositions & lps) const = 0;
      virtual const uint8_t *Decode(const uint8_t *pkt, const uint8_t *ptr,
                                    uint16_t pktlen, uint16_t rdlen) = 0;
    };
    
  }  // namespace Dns

}  // namespace Dwm

#endif  // _DWMDNSRRDATA_HH_
