//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.5/classes/src/DwmDnsRRDataAAAA.cc 10133 $
// @(#) $Id: DwmDnsRRDataAAAA.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataAAAA.cc
//!  \brief Dwm::Dns::RRDataAAAA class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
}

#include <cstring>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataAAAA.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.5/classes/src/DwmDnsRRDataAAAA.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataAAAA::RRDataAAAA()
    {
      memset(&_in6Addr, 0, sizeof(_in6Addr));
    }
   
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataAAAA::RRDataAAAA(const in6_addr & in6Addr)
        : _in6Addr(in6Addr)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataAAAA::operator == (const RRDataAAAA & aaaa) const
    {
      return (memcmp(&_in6Addr, &aaaa._in6Addr, sizeof(_in6Addr)) == 0);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const in6_addr & RRDataAAAA::In6Addr() const
    {
      return _in6Addr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const in6_addr & RRDataAAAA::In6Addr(const in6_addr & in6Addr)
    {
      _in6Addr = in6Addr;
      return _in6Addr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataAAAA::Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                                LabelPositions & lps) const
    {
      if (pkt && ptr && pktlen) {
        if ((ptr + sizeof(_in6Addr.s6_addr)) <= (pkt + pktlen)) {
          memcpy(ptr, &_in6Addr.s6_addr, sizeof(_in6Addr.s6_addr));
          ptr += sizeof(_in6Addr.s6_addr);
        }
        else {
          throw out_of_range("Dwm::Dns::RRDataAAAA will not fit in packet");
        }
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataAAAA::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                      uint16_t pktlen, uint16_t rdlen)
    {
      if (pkt && ptr && pktlen) {
        if (((ptr + sizeof(_in6Addr.s6_addr)) <= (pkt + pktlen))
            && (rdlen == sizeof(_in6Addr.s6_addr))) {
          memcpy(&_in6Addr.s6_addr, ptr, sizeof(_in6Addr.s6_addr));
          ptr += sizeof(_in6Addr.s6_addr);
        }
        else {
          throw out_of_range("packet too short for Dwm::Dns::RRDataAAAA");
        }
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (std::ostream & os, const RRDataAAAA & aaaa)
    {
      if (os) {
        char  buf[INET6_ADDRSTRLEN] = { 0 };
        inet_ntop(AF_INET6, &aaaa._in6Addr, buf, INET6_ADDRSTRLEN);
        os << buf;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
