//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.5/classes/src/DwmDnsNSECBitmap.cc 10133 $
// @(#) $Id: DwmDnsNSECBitmap.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsNSECBitmap.cc
//!  \brief Dwm::Dns::NSECBitmap class implementation
//---------------------------------------------------------------------------

#include <iomanip>
#include <sstream>

#include "DwmSvnTag.hh"
#include "DwmDnsNSECBitmap.hh"
#include "DwmDnsResourceRecord.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.5/classes/src/DwmDnsNSECBitmap.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    NSECBitmap::NSECBitmap()
        : _window(0), _bits()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    NSECBitmap::NSECBitmap(uint8_t window, const vector<uint8_t> & bits)
        : _window(window), _bits(bits)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool NSECBitmap::operator == (const NSECBitmap & bitmap) const
    {
      return ((_window == bitmap._window)
              && (_bits == bitmap._bits));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t NSECBitmap::Window() const
    {
      return _window;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t NSECBitmap::Window(uint8_t window)
    {
      _window = window;
      return _window;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<uint8_t> & NSECBitmap::Bits() const
    {
      return _bits;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<uint8_t> &
    NSECBitmap::Bits(const vector<uint8_t> & bits)
    {
      _bits = bits;
      return _bits;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *NSECBitmap::Encode(uint8_t *pkt, uint8_t *ptr,
                                uint16_t pktlen) const
    {
      if ((ptr + 1 + 1 + _bits.size()) <= (pkt + pktlen)
          && (_bits.size() < 256)) {
        *ptr++ = _window;
        *ptr++ = (uint8_t)(_bits.size() & 0xFF);
        for (auto octet : _bits) {
          *ptr++ = octet;
        }
      }
      else {
        throw out_of_range("Dwm::Dns::NSECBitmap will not fit in packet");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *NSECBitmap::Decode(const uint8_t *pkt,
                                      const uint8_t *ptr,
                                      uint16_t pktlen, uint16_t rdlen)
    {
      _window = 0;
      _bits.clear();
      if ((ptr + 2) <= (pkt + pktlen)) {
        _window = *ptr++;
        uint8_t  bitlen = *ptr++;
        if ((ptr + bitlen) <= (pkt + pktlen)) {
          for (uint8_t n = 0; n < bitlen; ++n) {
            uint8_t  octet = *ptr++;
            _bits.push_back(octet);
          }
        }
        else {
          throw out_of_range("packet too short to contain Dwm::Dns::NSECBitmap");
        }
        
      }
      else {
        throw out_of_range("packet too short to contain Dwm::Dns::NSECBitmap");
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const NSECBitmap & bitmap)
    {
      if (os) {
        if (! bitmap._bits.empty()) {
          for (auto byt = 0; byt < bitmap._bits.size(); ++byt) {
            uint8_t  mask = 0x80;
            for (uint8_t i = 0; i < 8; ++i) {
              if (bitmap._bits[byt] & mask) {
                uint16_t  rrtype = (bitmap._window * 256) + (byt * 8) + i;
                os << ' ' << ResourceRecord::TypeName(rrtype);
              }
              mask >>= 1;
            }
          }
        }
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
