%{
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in
//     the documentation and/or other materials provided with the
//     distribution.
//  3. All advertising materials mentioning features or use of this
//     software must display the following acknowledgement:
//
//      This product includes software developed by Daniel W. McRobb
//
//  4. The name Daniel W. McRobb may not be used to endorse or promote
//     products derived from this software without specific prior
//     written permission.
//
//  THIS SOFTWARE IS PROVIDED BY DANIEL W. MCROBB ``AS IS'' AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
//  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DANIEL W. MCROBB BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//===========================================================================

extern "C" {
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

  //  extern FILE  *resolvconfin;
}

#include <fstream>
#include <iostream>

#include "DwmDnsResolvConf.hh"

static const std::string rcsid = "@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.2/classes/src/DwmDnsResolvConfLexer.lex 10070 $";

using namespace std;
%}


m_ipAddr	[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+
m_ip6Addr [0-9a-fA-F:]+

%x x_domain
%x x_nameserver
%x x_searchlist
%x x_sortlist

%option noyywrap
%option prefix="resolvconf"

%%

<INITIAL>^domain[ \t]+          { BEGIN(x_domain); }
<x_domain>[A-Za-z0-9\.\-]+      { BEGIN(INITIAL); return(x_domain); }
<x_domain>.
<x_domain>\n                    { BEGIN(INITIAL); }
<INITIAL>^nameserver[ \t]+      { BEGIN(x_nameserver); }
<x_nameserver>{m_ipAddr}        { BEGIN(INITIAL); return(x_nameserver); }
<x_nameserver>{m_ip6Addr}       { BEGIN(INITIAL); return(x_nameserver); }
<x_nameserver>.
<x_nameserver>\n                { BEGIN(INITIAL); }
<INITIAL>^search[ \t]+          { BEGIN(x_searchlist); }
<x_searchlist>[A-Za-z0-9\.\-]+  { return(x_searchlist); }
<x_searchlist>[ ]
<x_searchlist>.
<x_searchlist>\n                { BEGIN(INITIAL); }
<INITIAL>.
<INITIAL>\n

%%

using namespace std;

namespace Dwm {

  namespace Dns {
    
    //------------------------------------------------------------------------
    //  
    //------------------------------------------------------------------------
    ResolvConf::ResolvConf(const string & filename)
    {
      resolvconfin = fopen(filename.c_str(), "r");
      if (resolvconfin) {
        int                     lexRc;
        while ((lexRc = resolvconflex()) != 0) {
          switch (lexRc) {
            case x_domain:
              this->Domain(resolvconftext);
              break;
            case x_nameserver:
              {
                struct in6_addr  in6Addr;
                struct in_addr   in4Addr;
                if (inet_pton(AF_INET6, resolvconftext, &in6Addr) == 1) {
                  this->_nameservers.push_back(NameServer(in6Addr));
                }
                else if (inet_pton(AF_INET, resolvconftext, &in4Addr) == 1) {
                  this->_nameservers.push_back(NameServer(in4Addr));
                }
              }
              break;
            case x_searchlist:
              this->_searchList.push_back(resolvconftext);
              break;
            default:
              break;
          }
        }
        fclose(resolvconfin);
      }
      
      if (this->_domain.length() == 0) {
        char  buf[256];
        memset(buf,0,256);
        if (gethostname(buf,255) == 0) {
          string domain(buf);
          string delimiters(".");
          string::size_type    domainBegin;
          domainBegin = domain.find_first_of(delimiters,0);
          if (domainBegin != domain.npos) {
            domainBegin++;
            this->_domain =
              domain.substr(domainBegin,domain.length() - domainBegin);
          }
        }
      }
    }
    
    //------------------------------------------------------------------------
    //  
    //------------------------------------------------------------------------
    vector<NameServer> & ResolvConf::Nameservers()
    {
      return(this->_nameservers);
    }
    
    //------------------------------------------------------------------------
    //  
    //------------------------------------------------------------------------
    const string & ResolvConf::Domain() const
    {
      return(this->_domain);
    }
    
    //------------------------------------------------------------------------
    //  
    //------------------------------------------------------------------------
    const string & ResolvConf::Domain(const string & domain)
    {
      this->_domain = domain;
      return(this->_domain);
    }
    
    //------------------------------------------------------------------------
    //  
    //------------------------------------------------------------------------
    const vector<string> & ResolvConf::SearchList() const
    {
      return(this->_searchList);
    }
    
  }  // namespace Dns

  
}  // namespace Dwm
