//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.2/classes/src/DwmDnsRRDataOPENPGPKEY.cc 10133 $
// @(#) $Id: DwmDnsRRDataOPENPGPKEY.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataOPENPGPKEY.cc
//!  \brief Dwm::Dns::RRDataOPENPGPKEY class implementation
//---------------------------------------------------------------------------

#include <cstring>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmBase64.hh"
#include "DwmDnsRRDataOPENPGPKEY.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.2/classes/src/DwmDnsRRDataOPENPGPKEY.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataOPENPGPKEY::RRDataOPENPGPKEY()
        : _publicKey()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataOPENPGPKEY::RRDataOPENPGPKEY(const string & publicKey)
        : _publicKey(publicKey)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool
    RRDataOPENPGPKEY::operator == (const RRDataOPENPGPKEY & openpgpkey) const
    {
      return (_publicKey == openpgpkey._publicKey);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataOPENPGPKEY::PublicKey() const
    {
      return _publicKey;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataOPENPGPKEY::PublicKey(const string & publicKey)
    {
      _publicKey = publicKey;
      return _publicKey;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataOPENPGPKEY::Encode(uint8_t *pkt, uint8_t *ptr,
                                      uint16_t pktlen,
                                      LabelPositions & lps) const
    {
      if ((ptr + _publicKey.size()) <= (pkt + pktlen)) {
        if (! _publicKey.empty()) {
          memcpy(ptr, _publicKey.c_str(), _publicKey.size());
          ptr += _publicKey.size();
        }
      }
      else {
        throw out_of_range("Dwm::Dns::RRDataOPENPGPKEY"
                           " will not fit in packet");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataOPENPGPKEY::Decode(const uint8_t *pkt,
                                            const uint8_t *ptr,
                                            uint16_t pktlen, uint16_t rdlen)
    {
      _publicKey.clear();
      if ((ptr + rdlen) <= (pkt + pktlen)) {
        _publicKey.assign((const char *)ptr, rdlen);
        ptr += rdlen;
      }
      else {
        throw out_of_range("packet too short to contain"
                           " Dwm::Dns::RRDataOPENPGPKEY");
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os,const RRDataOPENPGPKEY & pgpkey)
    {
      if (os) {
        os << Base64::Encode(pgpkey._publicKey);
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
