%{
 //===========================================================================
// @(#) $Name:$
// @(#) $Id: DwmDnsEtcHostsLexer.lex 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsEtcHostsLexer.lex
//!  \brief lexer for /etc/hosts
//---------------------------------------------------------------------------

  extern "C" {
    #include <stdio.h>
    void etchostserror(const char *msg)
    {
      fprintf(stderr, "Error: %s\n", msg);
      return;
    }
  }

  #include <utility>
  
  #include "DwmSvnTag.hh"
  #include "DwmDnsEtcHostsParser.hh"

  static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.2/classes/src/DwmDnsEtcHostsLexer.lex 10133 $");
%}

m_ipAddr  [0-9a-fA-F\.:]+

%option noyywrap
%option prefix="etchosts"

%x  x_name

%%

<INITIAL>[#].*\n
<INITIAL>{m_ipAddr}           { etchostslval.stringVal =
                                  new std::string(yytext);
                                BEGIN(x_name);
                                return(IPADDR); }
<INITIAL>[ \t\n]+
<x_name>[a-zA-Z0-9\-\.]+      { etchostslval.stringVal =
                                  new std::string(yytext);
                                return(NAME); }
<x_name>[ \t]+
<x_name>[#].*\n               { BEGIN(INITIAL); }
<x_name>\n                    { BEGIN(INITIAL); }

%%

