//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.2/classes/include/DwmDnsRRDataPTR.hh 10129 $
// @(#) $Id: DwmDnsRRDataPTR.hh 10129 2018-01-27 04:20:26Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataPTR.hh
//!  \brief Dwm::Dns::RRDataPTR class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSRRDATAPTR_HH_
#define _DWMDNSRRDATAPTR_HH_

#include <cstdint>
#include <string>

#include "DwmDnsRRDataDomainName.hh"

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  @ingroup rrdatagroup
    //!  Encapsulates PTR resource record data.  See RFC1035 for details.
    //------------------------------------------------------------------------
    class RRDataPTR
      : public RRDataDomainName
    {
    public:
      static const uint16_t  k_rrtype = 12;
      
      //----------------------------------------------------------------------
      //!  Construct with an empty domain name.
      //----------------------------------------------------------------------
      RRDataPTR() : RRDataDomainName() { }
      
      //----------------------------------------------------------------------
      //!  Construct with the given domain name @c ptr.
      //----------------------------------------------------------------------
      RRDataPTR(const std::string & ptr) : RRDataDomainName(ptr) { }
      
      //----------------------------------------------------------------------
      //!  Returns the contained domain name.
      //----------------------------------------------------------------------
      const std::string & Ptr() const  { return Value(); }
      
      //----------------------------------------------------------------------
      //!  Sets and returns the contained domain name.
      //----------------------------------------------------------------------
      const std::string & Ptr(const std::string & value)
      {
        return Value(value);
      }
    };
    
  }  // namespace Dns

}  // namespace Dwm

#endif  // _DWMDNSRRDATAPTR_HH_
