/*! @file DwmDnsDocMainPage.hh
 *  @brief Documentation main page (no source code)
 * 
 * \mainpage DwmDns Class Library
 *
 *  \section intro_sec Introduction
 *
 *  This library contains C++ classes for DNS message transmission and
 *  reception and a simple Resolver class.  While it requires libDwm,
 *  it is essentially a standalone DNS implementation for DNS client
 *  applications.
 *
 *  Most common resource record types are supported, and new resource
 *  record types are fairly easy to add.  The library was motivated
 *  by the lack of a decent C++ DNS library with liberal licensing.
 *
 *  Most applications will just use members of the Dwm::Dns::Resolver
 *  class to perform DNS lookups, and members of the associated resource
 *  record data class to retrieve usable data from the returned
 *  Dwm::Dns::ResourceRecord objects.  All resource record data classes
 *  derive from Dwm::Dns::RRData.
 *
 *  More advanced usage is possible via the Dwm::Dns::NameServer and
 *  Dwm::Dns::Message classes.
 *
 *  The library contains rudimentary support for EDNS, and the library
 *  supports DNSSEC record types.  The list of currently supported 
 *  resource record types:
 *
 *  <table>
 *    <tr>
 *      <th>Mnemonic</th>
 *      <th>Resource Record Type</th>
 *      <th>Reference</th>
 *      <th>Data class</th>
 *    </tr>
 *    <tr><td>A</td><td>1</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataA</td>
 *    </tr>
 *    <tr><td>NS</td><td>2</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataNS</td>
 *    </tr>
 *    <tr><td>CNAME</td><td>5</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataCNAME</td>
 *    </tr>
 *    <tr><td>SOA</td><td>6</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataSOA</td>
 *    </tr>
 *    <tr><td>MB</td><td>7</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataMB</td>
 *    </tr>
 *    <tr><td>MG</td><td>8</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataMG</td>
 *    </tr>
 *    <tr><td>MR</td><td>9</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataMR</td>
 *    </tr>
 *    <tr><td>PTR</td><td>12</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataPTR</td>
 *    </tr>
 *    <tr><td>HINFO</td><td>13</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataHINFO</td>
 *    </tr>
 *    <tr><td>MINFO</td><td>14</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataMINFO</td>
 *    </tr>
 *    <tr><td>MX</td><td>15</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataMX</td>
 *    </tr>
 *    <tr><td>TXT</td><td>16</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a></td>
 *      <td>Dwm::Dns::RRDataTXT</td>
 *    </tr>
 *    <tr><td>RP</td><td>17</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1183">RFC 1183</a></td>
 *      <td>Dwm::Dns::RRDataRP</td>
 *    </tr>
 *    <tr><td>KEY</td><td>25</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4034">RFC 4034</a></td>
 *      <td>Dwm::Dns::RRDataKEY</td>
 *    </tr>
 *    <tr><td>AAAA</td><td>28</td>
 *      <td><a href="https://tools.ietf.org/html/rfc3596">RFC 3596</a></td>
 *      <td>Dwm::Dns::RRDataAAAA</td>
 *    </tr>
 *    <tr><td>LOC</td><td>29</td>
 *      <td><a href="https://tools.ietf.org/html/rfc1876">RFC 1876</a></td>
 *      <td>Dwm::Dns::RRDataLOC</td>
 *    </tr>
 *    <tr><td>SRV</td><td>33</td>
 *      <td><a href="https://tools.ietf.org/html/rfc2782">RFC 2782</a></td>
 *      <td>Dwm::Dns::RRDataSRV</td>
 *    </tr>
 *    <tr><td>CERT</td><td>37</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4398">RFC 4398</a></td>
 *      <td>Dwm::Dns::RRDataCERT</td>
 *    </tr>
 *    <tr><td>DS</td><td>43</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4034">RFC 4034</a></td>
 *      <td>Dwm::Dns::RRDataDS</td>
 *    </tr>
 *    <tr><td>SSHFP</td><td>44</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4255">RFC 4255</a></td>
 *      <td>Dwm::Dns::RRDataSSHFP</td>
 *    </tr>
 *    <tr><td>RRSIG</td><td>46</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4034">RFC 4034</a></td>
 *      <td>Dwm::Dns::RRDataRRSIG</td>
 *    </tr>
 *    <tr><td>NSEC</td><td>47</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4034">RFC 4034</a></td>
 *      <td>Dwm::Dns::RRDataNSEC</td>
 *    </tr>
 *    <tr><td>DNSKEY</td><td>48</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4034">RFC 4034</a></td>
 *      <td>Dwm::Dns::RRDataDNSKEY</td>
 *    </tr>
 *    <tr><td>DHCID</td><td>49</td>
 *      <td><a href="https://tools.ietf.org/html/rfc4071">RFC 4071</a></td>
 *      <td>Dwm::Dns::RRDataDHCID</td>
 *    </tr>
 *    <tr><td>NSEC3</td><td>50</td>
 *      <td><a href="https://tools.ietf.org/html/rfc5155">RFC 5155</a></td>
 *      <td>Dwm::Dns::RRDataNSEC3</td>
 *    </tr>
 *    <tr><td>NSEC3PARAM</td><td>51</td>
 *      <td><a href="https://tools.ietf.org/html/rfc5155">RFC 5155</a></td>
 *      <td>Dwm::Dns::RRDataNSEC3PARAM</td>
 *    </tr>
 *    <tr><td>TLSA</td><td>52</td>
 *      <td><a href="https://tools.ietf.org/html/rfc6698">RFC 6698</a></td>
 *      <td>Dwm::Dns::RRDataTLSA</td>
 *    </tr>
 *    <tr><td>SMIMEA</td><td>53</td>
 *      <td><a href="https://tools.ietf.org/html/rfc8162">RFC 8162</a></td>
 *      <td>Dwm::Dns::RRDataSMIMEA</td>
 *    </tr>
 *    <tr><td>CDS</td><td>59</td>
 *      <td><a href="https://tools.ietf.org/html/rfc7344">RFC 7344</a></td>
 *      <td>Dwm::Dns::RRDataDS</td>
 *    </tr>
 *    <tr><td>CDNSKEY</td><td>60</td>
 *      <td><a href="https://tools.ietf.org/html/rfc7344">RFC 7344</a></td>
 *      <td>Dwm::Dns::RRDataDNSKEY</td>
 *    </tr>
 *    <tr><td>OPENPGPKEY</td><td>61</td>
 *      <td><a href="https://tools.ietf.org/html/rfc7929">RFC 7929</a></td>
 *      <td>Dwm::Dns::RRDataOPENPGPKEY</td>
 *    </tr>
 *    <tr><td>URI</td><td>256</td>
 *      <td><a href="https://tools.ietf.org/html/rfc7553">RFC 7553</a></td>
 *      <td>Dwm::Dns::RRDataURI</td>
 *    </tr>
 *    <tr><td>CAA</td><td>257</td>
 *      <td><a href="https://tools.ietf.org/html/rfc6844">RFC 6844</a></td>
 *      <td>Dwm::Dns::RRDataCAA</td>
 *    </tr>
 *  </table>
 *
 *  \section requirements_sec Requirements
 *
 *  libDwm is needed to compile the library.
 *
 *  We need an implementation of @c variant for resource record data.
 *  Depending on your installed C++ library and compiler, you may have
 *  it (it's part of the C++17 standard).  The @c configure script will
 *  check if you have it, and fall back to using mpark::variant from
 *  Michael Park if the standard version is not found.  This fallback
 *  is included in the @c mpark_variant header file I include with the
 *  library source.  Note that the fallback appears to fill this 
 *  requirement for older compilers such as g++ 6.3.0, clang on macOS 
 *  Sierra, etc.  In other words, you don't need full C++17 support.
 *
 *  \section history_sec History
 *
 *  Some of the library code dates back to the year 2000 when we didn't
 *  have widespread resolver support for various types of records
 *  newer than those in RFC 1035.  I've since significantly refactored the
 *  code twice, in 2016 and 2017/2018.  Some functionality was lost in the
 *  refactoring, which will likely return when I find time to work on it.
 *  And there are currently a few nits to fix, like the TCP fallback
 *  in the Dwm::Dns::Resolver class not set to always be used when the
 *  TC (truncated) bit is set in the UDP response from a name server.
 *  But as a first release, I think the library is definitely in a 
 *  usable state for many C++ applications that have needs beyond what's
 *  possible with getaddrinfo() and getnameinfo().  Especially those
 *  applications that want a C++ API.
 */
