//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.1/classes/src/DwmDnsRRDataMX.cc 10133 $
// @(#) $Id: DwmDnsRRDataMX.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataMX.cc
//!  \brief Dwm::Dns::RRDataMX class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <arpa/inet.h>
}

#include <cstring>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsLabelSequence.hh"
#include "DwmDnsRRDataMX.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.1/classes/src/DwmDnsRRDataMX.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataMX::RRDataMX()
        : _preference(0), _exchange()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataMX::RRDataMX(uint16_t preference, const std::string & exchange)
        : _preference(preference), _exchange(exchange)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataMX::operator == (const RRDataMX & mx) const
    {
      return ((_preference == mx._preference)
              && (_exchange == mx._exchange));
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint16_t RRDataMX::Preference() const
    {
      return _preference;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint16_t RRDataMX::Preference(uint16_t preference)
    {
      _preference = preference;
      return _preference;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataMX::Exchange() const
    {
      return _exchange;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataMX::Exchange(const std::string & exchange)
    {
      _exchange = exchange;
      return _exchange;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataMX::Encode(uint8_t *pkt, uint8_t *ptr,
                              uint16_t pktlen, LabelPositions & lps) const
    {
      if ((ptr + 2) <= (pkt + pktlen)) {
        uint16_t  u16val = htons(_preference);
        memcpy(ptr, &u16val, sizeof(u16val));
        ptr += sizeof(uint16_t);
        LabelSequence  ls(_exchange);
        ptr = ls.Encode(pkt, ptr, pktlen, lps);
      }
      else {
        throw out_of_range("Dwm::Dns::RRDataMX will not fit in packet");
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataMX::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                    uint16_t pktlen, uint16_t rdlen)
    {
      _preference = 0;
      _exchange.clear();
      if ((ptr + 2) <= (pkt + pktlen)) {
        uint16_t  u16val;
        memcpy(&u16val, ptr, sizeof(u16val));
        _preference = ntohs(u16val);
        ptr += 2;
        LabelSequence  ls;
        ptr = ls.Decode(pkt, ptr, pktlen);
        _exchange = (string)ls;
      }
      else {
        throw out_of_range("packet too short to contain Dwm::Dns::RRDataMX");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataMX & mx)
    {
      if (os) {
        os << mx._preference << ' ' << mx._exchange;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
