//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.1/classes/include/DwmDnsResolvConf.hh 10136 $
// @(#) $Id: DwmDnsResolvConf.hh 10136 2018-01-28 06:01:09Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsResolvConf.hh
//!  \brief Dwm::Dns::ResolvConf class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSRESOLVCONF_HH_
#define _DWMDNSRESOLVCONF_HH_

extern "C" {
  #include <netinet/in.h>
}

#include <cstdint>
#include <string>
#include <vector>

#include "DwmDnsNameServer.hh"

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  @ingroup resolvergroup
    //!  Encapsulates the contents of a resolver configuration file
    //!  (@c /etc/rc.conf).
    //------------------------------------------------------------------------
    class ResolvConf
    {
    public:
      //----------------------------------------------------------------------
      //!  Construct from a resolver configuration file.
      //----------------------------------------------------------------------
      ResolvConf(const std::string & filename = "/etc/resolv.conf");
      
      //----------------------------------------------------------------------
      //!  Return the vector of nameservers.
      //----------------------------------------------------------------------
      std::vector<NameServer> & Nameservers();
      
      //----------------------------------------------------------------------
      //!  Returns the local domain.
      //----------------------------------------------------------------------
      const std::string & Domain() const;
      
      //----------------------------------------------------------------------
      //!  Sets and returns the local domain.
      //----------------------------------------------------------------------
      const std::string & Domain(const std::string & domain);
      
      //----------------------------------------------------------------------
      //!  Returns the domain search list.
      //----------------------------------------------------------------------
      const std::vector<std::string> & SearchList() const;
      
    private:
      std::vector<NameServer>   _nameservers;
      std::string               _domain;
      std::vector<std::string>  _searchList;
    };
    
  }  // namespace Dns
  
}  // namespace Dwm

#endif  // _DWMDNSRESOLVCONF_HH_
