//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.2.1/classes/include/DwmDnsRRDataUnknown.hh 10125 $
// @(#) $Id: DwmDnsRRDataUnknown.hh 10125 2018-01-27 02:42:53Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataUnknown.hh
//!  \brief Dwm::Dns::RRDataUnknown class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSRRDATAUNKNOWN_HH_
#define _DWMDNSRRDATAUNKNOWN_HH_

#include <cstdint>
#include <iostream>
#include <string>

#include "DwmDnsLabelPositions.hh"

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  Encapsulates resource record data for unknown resource record types.
    //------------------------------------------------------------------------
    class RRDataUnknown
    {
    public:
      RRDataUnknown();
      RRDataUnknown(const std::string & data);
      bool operator == (const RRDataUnknown & unknown) const;
      const std::string & Data() const;
      const std::string	& Data(const std::string & data);
      uint8_t *Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                      LabelPositions & lps) const;
      const uint8_t *Decode(const uint8_t *pkt, const uint8_t *ptr,
                            uint16_t pktlen, uint16_t rdlen);
      friend std::ostream & operator << (std::ostream & os,
                                         const RRDataUnknown & a);

    private:
      std::string  _data;
    };
    
  }  // namespace Dns

}  // namespace Dwm

#endif  // _DWMDNSRRDATAUNKNOWN_HH_
