//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataSSHFP.cc 10133 $
// @(#) $Id: DwmDnsRRDataSSHFP.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataSSHFP.cc
//!  \brief Dwm::Dns::RRDataSSHFP class implementation
//---------------------------------------------------------------------------

#include <cstring>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataSSHFP.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataSSHFP.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataSSHFP::RRDataSSHFP()
        : _algorithm(0), _fpType(0), _fingerprint()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataSSHFP::RRDataSSHFP(uint8_t algorithm, uint8_t fpType,
                             const string & fingerprint)
        : _algorithm(algorithm), _fpType(fpType), _fingerprint(fingerprint)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataSSHFP::operator == (const RRDataSSHFP & sshfp) const
    {
      return ((_algorithm == sshfp._algorithm)
              && (_fpType == sshfp._fpType)
              && (_fingerprint == sshfp._fingerprint));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t RRDataSSHFP::Algorithm() const
    {
      return _algorithm;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t RRDataSSHFP::Algorithm(uint8_t algorithm)
    {
      _algorithm = algorithm;
      return _algorithm;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t RRDataSSHFP::FPType() const
    {
      return _fpType;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t RRDataSSHFP::FPType(uint8_t fpType)
    {
      _fpType = fpType;
      return _fpType;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSSHFP::Fingerprint() const
    {
      return _fingerprint;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSSHFP::Fingerprint(const string & fingerprint)
    {
      _fingerprint = fingerprint;
      return _fingerprint;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataSSHFP::Encode(uint8_t *pkt, uint8_t *ptr,
                                 uint16_t pktlen, LabelPositions & lps) const
    {
      if ((ptr + 2) <= (pkt + pktlen)) {
        *ptr++ = _algorithm;
        *ptr++ = _fpType;
        if (_fingerprint.size() > 0) {
          if ((ptr + _fingerprint.size()) <= (pkt + pktlen)) {
            memcpy(ptr, _fingerprint.c_str(), _fingerprint.size());
            ptr += _fingerprint.size();
          }
          else {
            throw out_of_range("Dwm::Dns::RRDataSSHFP will not fit in packet");
          }
        }
      }
      else {
        throw out_of_range("Dwm::Dns::RRDataSSHFP will not fit in packet");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataSSHFP::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                       uint16_t pktlen, uint16_t rdlen)
    {
      _algorithm = 0;
      _fpType = 0;
      _fingerprint.clear();

      int             bytesLeft = rdlen;
      const uint8_t  *origptr = ptr;
      if ((ptr + 2) <= (pkt + pktlen)) {
        _algorithm = *ptr++;
        _fpType = *ptr++;
        bytesLeft -= (ptr - origptr);
        if (bytesLeft > 0) {
          _fingerprint.assign((const char *)ptr, bytesLeft);
          ptr += bytesLeft;
        }
      }
      else {
        throw out_of_range("packet too short to contain Dwm::Dns::RRDataSSHFP");
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataSSHFP & sshfp)
    {
      if (os) {
        os << (uint16_t)sshfp._algorithm << ' '
           << (uint16_t)sshfp._fpType << ' '
           << sshfp._fingerprint;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
