//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataSOA.cc 10133 $
// @(#) $Id: DwmDnsRRDataSOA.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataSOA.cc
//!  \brief Dwm::Dns::RRDataSOA class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <arpa/inet.h>
}

#include <cstring>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsLabelSequence.hh"
#include "DwmDnsRRDataSOA.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataSOA.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataSOA::RRDataSOA()
        : _mname(), _rname(), _serial(0), _refresh(0), _retry(0), _expire(0),
          _minimum(0)
    {
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataSOA::RRDataSOA(const string & mname, const string & rname,
                         uint32_t serial, uint32_t refresh, uint32_t retry,
                         uint32_t expire, uint32_t minimum)
        : _mname(mname), _rname(rname), _serial(serial), _refresh(refresh),
          _retry(retry), _expire(expire), _minimum(minimum)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataSOA::operator == (const RRDataSOA & soa) const
    {
      return ((_mname == soa._mname)
              && (_rname == soa._rname)
              && (_serial == soa._serial)
              && (_refresh == soa._refresh)
              && (_retry == soa._retry)
              && (_expire == soa._expire)
              && (_minimum == soa._minimum));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSOA::Mname() const
    {
      return _mname;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSOA::Mname(const string & mname)
    {
      _mname = mname;
      return _mname;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSOA::Rname() const
    {
      return _rname;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataSOA::Rname(const string & rname)
    {
      _rname = rname;
      return _rname;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Serial() const
    {
      return _serial;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Serial(uint32_t serial)
    {
      _serial = serial;
      return _serial;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Refresh() const
    {
      return _refresh;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Refresh(uint32_t refresh)
    {
      _refresh = refresh;
      return _refresh;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Retry() const
    {
      return _retry;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Retry(uint32_t retry)
    {
      _retry = retry;
      return _retry;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Expire() const
    {
      return _expire;
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Expire(uint32_t expire)
    {
      _expire = expire;
      return _expire;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Minimum() const
    {
      return _minimum;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t RRDataSOA::Minimum(uint32_t minimum)
    {
      _minimum = minimum;
      return _minimum;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataSOA::Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                               LabelPositions & lps) const
    {
      LabelSequence  mls(_mname);
      ptr = mls.Encode(pkt, ptr, pktlen, lps);
      LabelSequence  rls(_rname);
      ptr = rls.Encode(pkt, ptr, pktlen, lps);
      if ((ptr + 20) <= (pkt + pktlen)) {
        uint32_t  u32val = htonl(_serial);
        memcpy(ptr, &u32val, sizeof(u32val));
        ptr += sizeof(u32val);
        u32val = htonl(_refresh);
        memcpy(ptr, &u32val, sizeof(u32val));
        ptr += sizeof(u32val);
        u32val = htonl(_retry);
        memcpy(ptr, &u32val, sizeof(u32val));
        ptr += sizeof(u32val);
        u32val = htonl(_expire);
        memcpy(ptr, &u32val, sizeof(u32val));
        ptr += sizeof(u32val);
        u32val = htonl(_minimum);
        memcpy(ptr, &u32val, sizeof(u32val));
        ptr += sizeof(u32val);
      }
      else {
        throw out_of_range("Dwm::Dns::RRDataSOA will not fit in packet");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataSOA::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                     uint16_t pktlen, uint16_t rdlen)
    {
      LabelSequence  ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _mname = (string)ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _rname = (string)ls;
      if ((ptr + 20) <= (pkt + pktlen)) {
        uint32_t  u32val;
        memcpy(&u32val, ptr, sizeof(u32val));
        _serial = ntohl(u32val);
        ptr += sizeof(u32val);
        memcpy(&u32val, ptr, sizeof(u32val));
        _refresh = ntohl(u32val);
        ptr += sizeof(u32val);
        memcpy(&u32val, ptr, sizeof(u32val));
        _retry = ntohl(u32val);
        ptr += sizeof(u32val);
        memcpy(&u32val, ptr, sizeof(u32val));
        _expire = ntohl(u32val);
        ptr += sizeof(u32val);
        memcpy(&u32val, ptr, sizeof(u32val));
        _minimum = ntohl(u32val);
        ptr += sizeof(u32val);
      }
      else {
        throw out_of_range("packet too short to contain Dwn::Dns::RRDataSOA");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataSOA & soa)
    {
      if (os) {
        os << soa._mname << ' ' << soa._rname << ' ' << soa._serial << ' '
           << soa._refresh << ' ' << soa._retry << ' ' << soa._expire << ' '
           << soa._minimum;
      }
      return os;
    }
    

  }  // namespace Dns

}  // namespace Dwm
