//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataMINFO.cc 10133 $
// @(#) $Id: DwmDnsRRDataMINFO.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataMINFO.cc
//!  \brief Dwm::Dns::RRDataMINFO class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmDnsLabelSequence.hh"
#include "DwmDnsRRDataMINFO.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataMINFO.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataMINFO::RRDataMINFO()
        : _rmailbx(), _emailbx()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataMINFO::RRDataMINFO(const string & rmailbx, const string & emailbx)
        : _rmailbx(rmailbx), _emailbx(emailbx)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataMINFO::operator == (const RRDataMINFO & minfo) const
    {
      return ((_rmailbx == minfo._rmailbx)
              && (_emailbx == minfo._emailbx));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataMINFO::Rmailbx() const
    {
      return _rmailbx;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataMINFO::Rmailbx(const string & rmailbx)
    {
      _rmailbx = rmailbx;
      return _rmailbx;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataMINFO::Emailbx() const
    {
      return _emailbx;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataMINFO::Emailbx(const string & emailbx)
    {
      _emailbx = emailbx;
      return _emailbx;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataMINFO::Encode(uint8_t *pkt, uint8_t *ptr,
                                 uint16_t pktlen, LabelPositions & lps) const
    {
      LabelSequence  rls(_rmailbx);
      ptr = rls.Encode(pkt, ptr, pktlen, lps);
      LabelSequence  els(_emailbx);
      ptr = els.Encode(pkt, ptr, pktlen, lps);
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataMINFO::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                       uint16_t pktlen, uint16_t rdlen)
    {
      LabelSequence  ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _rmailbx = (string)ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _emailbx = (string)ls;
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataMINFO & minfo)
    {
      if (os) {
        os << minfo._rmailbx << ' ' << minfo._emailbx;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
