//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataHINFO.cc 10133 $
// @(#) $Id: DwmDnsRRDataHINFO.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataHINFO.cc
//!  \brief Dwm::Dns::RRDataHINFO class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataHINFO.hh"
#include "DwmDnsUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsRRDataHINFO.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataHINFO::RRDataHINFO()
        : _cpu(), _os()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataHINFO::RRDataHINFO(const std::string & cpu, const std::string & os)
        : _cpu(cpu), _os(os)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataHINFO::operator == (const RRDataHINFO & hinfo) const
    {
      return ((_cpu == hinfo._cpu)
              && (_os == hinfo._os));
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataHINFO::Cpu() const
    {
      return _cpu;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataHINFO::Cpu(const std::string & cpu)
    {
      _cpu = cpu;
      return _cpu;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataHINFO::Os() const
    {
      return _os;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataHINFO::Os(const std::string & os)
    {
      _os = os;
      return _os;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataHINFO::Encode(uint8_t *pkt, uint8_t *ptr,
                                 uint16_t pktlen, LabelPositions & lps) const
    {
      ptr = EncodeCharacterString(_cpu, pkt, ptr, pktlen);
      ptr = EncodeCharacterString(_os, pkt, ptr, pktlen);
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataHINFO::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                       uint16_t pktlen, uint16_t rdlen)
    {
      _cpu.clear();
      _os.clear();
      ptr = DecodeCharacterString(_cpu, pkt, ptr, pktlen);
      ptr = DecodeCharacterString(_os, pkt, ptr, pktlen);
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream &	os, const RRDataHINFO & hinfo)
    {
      if (os) {
        os << hinfo._cpu << ' ' << hinfo._os;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
