//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsLabelPositions.cc 10133 $
// @(#) $Id: DwmDnsLabelPositions.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsLabelPositions.cc
//!  \brief Dwm::Dns::LabelPositions class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmDnsLabelPositions.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/src/DwmDnsLabelPositions.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    LabelPositions::LabelPositions()
        : _positions()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LabelPositions::Add(const string & s, uint16_t offset)
    {
      auto  i = _positions.find(s);
      if (i == _positions.end()) {
        _positions[s] = offset;
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LabelPositions::Add(const vector<pair<string,uint16_t>> & labels,
                             const string & domain)
    {
      string  s = domain;
      for (auto ri = labels.rbegin(); ri != labels.rend(); ++ri) {
        s = ri->first + '.' + s;
        Add(s, ri->second);
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LabelPositions::Add(const vector<pair<string,uint16_t>> & labels)
    {
      if (! labels.empty()) {
        auto ri = labels.rbegin();
        string  s = ri->first;
        Add(s, ri->second);
        ++ri;
        for ( ; ri != labels.rend(); ++ri) {
          s = ri->first + '.' + s;
          Add(s, ri->second);
        }
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool LabelPositions::GetSubstrings(const string & s, vector<string> & vs)
    {
      if (s.size() > 1) {
        string::size_type  eidx = s.size() - 2;
        for (int i = eidx; i >= 0; --i) {
          if (s[i] == '.') {
            vs.push_back(s.substr(i+1));
          }
        }
        if (s[0] != '.') {
          vs.push_back(s);
        }
      }
      return (! vs.empty());
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    pair<string,uint16_t>
    LabelPositions::FindLongestPrev(const string & s) const
    {
      pair<string,uint16_t>  longest("", 0xFFFF);
      if (! s.empty()) {
        vector<string>  subStrings;
        if (GetSubstrings(s, subStrings)) {
          for (auto & ss : subStrings) {
            auto  i = _positions.find(ss);
            if (i != _positions.end()) {
              longest = *i;
            }
          }
        }
      }
      return longest;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void LabelPositions::Clear()
    {
      _positions.clear();
    }
    
  }  // namespace Dns

}  // namespace Dwm
