//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/include/DwmDnsRRDataOPENPGPKEY.hh 10129 $
// @(#) $Id: DwmDnsRRDataOPENPGPKEY.hh 10129 2018-01-27 04:20:26Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataOPENPGPKEY.hh
//!  \brief Dwm::Dns::RRDataOPENPGPKEY class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSRRDATAOPENPGPKEY_HH_
#define _DWMDNSRRDATAOPENPGPKEY_HH_

#include <cstdint>
#include <iostream>
#include <string>

#include "DwmDnsRRData.hh"

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  @ingroup rrdatagroup
    //!  Encapsulates OPENPGKPEY resource record data.  See RFC7929 for
    //!  details.
    //------------------------------------------------------------------------
    class RRDataOPENPGPKEY
      : public RRData
    {
    public:
      static const uint16_t  k_rrtype = 61;
      
      //----------------------------------------------------------------------
      //!  Construct with empty public key.
      //----------------------------------------------------------------------
      RRDataOPENPGPKEY();
      
      //----------------------------------------------------------------------
      //!  Construct with the given @c publicKey.
      //----------------------------------------------------------------------
      RRDataOPENPGPKEY(const std::string & publicKey);
      
      //----------------------------------------------------------------------
      //!  Equal-to operator
      //----------------------------------------------------------------------
      bool operator == (const RRDataOPENPGPKEY & openpgpkey) const;
      
      //----------------------------------------------------------------------
      //!  Returns the contained public key.
      //----------------------------------------------------------------------
      const std::string & PublicKey() const;
      
      //----------------------------------------------------------------------
      //!  Sets and returns the contained public key
      //----------------------------------------------------------------------
      const std::string	& PublicKey(const std::string	& publicKey);
      
      //----------------------------------------------------------------------
      //!  Encodes the OPENPGPKEY resource record data into buffer @ pkt of
      //!  length @c pktlen, starting at @c ptr.  Returns the address
      //!  immediately following the encoded OPENPGPKEY resource record data
      //!  in @c pkt on success.  Throws std::out_of_range if @c pkt is too
      //!  short to contain the encoded OPENPGPKEY resource record data.
      //----------------------------------------------------------------------
      uint8_t *Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                      LabelPositions & lps) const;
      
      //----------------------------------------------------------------------
      //!  Decodes the OPENPGPKEY resource record data from buffer @c pkt of
      //!  length @c pktlen, starting at @c ptr.  Returns the address
      //!  immediately following the encoded OPENPGPKEY resource record data
      //!  in @c pkt on success.  Throws std::out_of_range if @c pkt was too
      //!  short to contain an encoded OPENPGPKEY resource record data.
      //----------------------------------------------------------------------
      const uint8_t *Decode(const uint8_t *pkt, const uint8_t *ptr,
                            uint16_t pktlen, uint16_t rdlen);

      //----------------------------------------------------------------------
      //!  Print the NSEC3PARAM resource record data to an ostream in human
      //!  readable form.
      //----------------------------------------------------------------------
      friend std::ostream & operator << (std::ostream & os,
                                         const RRDataOPENPGPKEY & pgpkey);
      
    private:
      std::string  _publicKey;
    };
    
  }  // namespace Dns

}  // namespace Dwm

#endif  // _DWMDNSRRDATAOPENPGPKEY_HH_
