//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.1/classes/include/DwmDnsLabelPositions.hh 10082 $
// @(#) $Id: DwmDnsLabelPositions.hh 10082 2018-01-26 03:47:10Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsLabelPositions.hh
//!  \brief Dwm::Dns::LabelPositions class definition
//---------------------------------------------------------------------------

#ifndef _DWMDNSLABELPOSITIONS_HH_
#define _DWMDNSLABELPOSITIONS_HH_

#include <cstdint>
#include <map>
#include <string>
#include <vector>

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  A helper class used when performing label sequence compression.
    //------------------------------------------------------------------------
    class LabelPositions
    {
    public:
      //----------------------------------------------------------------------
      //!  Constructor
      //----------------------------------------------------------------------
      LabelPositions();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Add(const std::string & s, uint16_t offset);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Add(const std::vector<std::pair<std::string,uint16_t>> & labels,
               const std::string & domain);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Add(const std::vector<std::pair<std::string,uint16_t>> & labels);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      std::pair<std::string,uint16_t>
      FindLongestPrev(const std::string & s) const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Clear();
        
    private:
      std::map<std::string,uint16_t>  _positions;

      static bool
      GetSubstrings(const std::string & s, std::vector<std::string> & vs);
    };
    
  }  // namespace Dns

}  // namespace Dwm

#endif  // _DWMDNSLABELPOSITIONS_HH_
