//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestDnsEtcHosts.cc 10062 2018-01-22 03:44:02Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestDnsEtcHosts.cc
//!  \brief unit tests for Dwm::Dns::EtcHosts
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmUnitAssert.hh"
#include "DwmDnsEtcHosts.hh"
#include "DwmDnsUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/tests/TestDnsEtcHosts.cc 10062 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  Dns::EtcHosts  etcHosts("./hosts");
  vector<Dns::ResourceRecord>  results;

  UnitAssert(etcHosts.Get("localhost", Dns::ResourceRecord::k_typeA,
                          results));
  if (UnitAssert(results.size() == 1)) {
    UnitAssert(results[0].Data<Dns::RRDataA>()->InAddr().s_addr
               == inet_addr("127.0.0.1"));
  }

  UnitAssert(etcHosts.Get("127.0.0.1", Dns::ResourceRecord::k_typePTR,
                          results));
  if (UnitAssert(results.size() == 2)) {
    for (auto & rr : results) {
      UnitAssert((rr.Data<Dns::RRDataPTR>()->Ptr() == "localhost")
                 || (rr.Data<Dns::RRDataPTR>()->Ptr()
                     == "localhost.rfdm.com"));
    }
  }

  UnitAssert(etcHosts.Get("localhost", Dns::ResourceRecord::k_typeAAAA,
                          results));
  if (UnitAssert(results.size() == 1)) {
    in6_addr  in6Addr;
    inet_pton(AF_INET6, "::1", &in6Addr);
    UnitAssert(results[0].Data<Dns::RRDataAAAA>()->In6Addr()
               == in6Addr);
  }

  UnitAssert(etcHosts.Get("::1", Dns::ResourceRecord::k_typePTR, results));
  if (UnitAssert(results.size() == 2)) {
    for (auto & rr : results) {
      UnitAssert((rr.Data<Dns::RRDataPTR>()->Ptr() == "localhost")
                 || (rr.Data<Dns::RRDataPTR>()->Ptr()
                     == "localhost.rfdm.com"));
    }
  }

  UnitAssert(etcHosts.Get("somehost", Dns::ResourceRecord::k_typeAAAA,
                          results));
  if (UnitAssert(results.size() == 1)) {
    in6_addr  in6Addr;
    inet_pton(AF_INET6, "fd60:3019:f4a:5cab::3", &in6Addr);
    UnitAssert(results[0].Data<Dns::RRDataAAAA>()->In6Addr()
               == in6Addr);
  }

  UnitAssert(etcHosts.Get("fd60:3019:f4a:5cab::3",
                          Dns::ResourceRecord::k_typePTR, results));
  if (UnitAssert(results.size() == 2)) {
    for (auto & rr : results) {
      UnitAssert((rr.Data<Dns::RRDataPTR>()->Ptr() == "somehost")
                 || (rr.Data<Dns::RRDataPTR>()->Ptr()
                     == "somehost.rfdm.com"));
    }
  }
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
    return 1;
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
    return 0;
  }
}
