//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataUnknown.cc 10075 $
// @(#) $Id: DwmDnsRRDataUnknown.cc 10075 2018-01-25 02:59:37Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataUnknown.cc
//!  \brief Dwm::Dns::RRDataUnknown class implementation
//---------------------------------------------------------------------------

#include <cstring>
#include <iomanip>
#include <sstream>

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataUnknown.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataUnknown.cc 10075 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataUnknown::RRDataUnknown()
        : _data()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataUnknown::RRDataUnknown(const string & data)
        : _data(data)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataUnknown::operator == (const RRDataUnknown & unknown) const
    {
      return (_data == unknown._data);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & RRDataUnknown::Data() const
    {
      return _data;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string	& RRDataUnknown::Data(const string & data)
    {
      _data = data;
      return _data;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataUnknown::Encode(uint8_t *pkt, uint8_t *ptr,
                                   uint16_t pktlen,
                                   LabelPositions & lps) const
    {
      if ((ptr + _data.size()) < (pkt + pktlen)) {
        if (! _data.empty()) {
          memcpy(ptr, _data.c_str(), _data.size());
          ptr += _data.size();
        }
      }
      else {
        throw out_of_range("Dwm::Dns::RRDataUnknown will not fit in packet");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataUnknown::Decode(const uint8_t *pkt,
                                         const uint8_t *ptr,
                                         uint16_t pktlen, uint16_t rdlen)
    {
      _data.clear();
      if ((ptr + rdlen) < (pkt + pktlen)) {
        _data.assign((const char *)ptr, rdlen);
        ptr += rdlen;
      }
      else {
        throw out_of_range("packet too short to contain"
                           " Dwm::Dns::RRDataUnknown");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataUnknown & unknown)
    {
      if (os) {
        if (! unknown._data.empty()) {
          os << "Unknown ";
          ostringstream  oss;
          oss << setfill('0') << hex << "0x";
          for (auto c : unknown._data) {
            oss << setw(2) << c;
          }
          os << oss.str();
        }
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
