//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataTXT.cc 10133 $
// @(#) $Id: DwmDnsRRDataTXT.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataTXT.cc
//!  \brief Dwm::Dns::RRDataTXT class implementation
//---------------------------------------------------------------------------

#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataTXT.hh"
#include "DwmDnsUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataTXT.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataTXT::RRDataTXT()
        : _txt()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataTXT::RRDataTXT(const vector<string> & txt)
        : _txt(txt)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataTXT::operator == (const RRDataTXT & txt) const
    {
      return (_txt == txt._txt);
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<string> & RRDataTXT::Txt() const
    {
      return _txt;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const vector<string> & RRDataTXT::Txt(const vector<string> & txt)
    {
      _txt = txt;
      return _txt;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataTXT::Encode(uint8_t *pkt, uint8_t *ptr,
                               uint16_t pktlen, LabelPositions & lps) const
    {
      for (auto & t : _txt) {
        ptr = EncodeCharacterString(t, pkt, ptr, pktlen);
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataTXT::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                     uint16_t pktlen, uint16_t rdlen)
    {
      _txt.clear();
      const uint8_t  *origptr = ptr;
      int             bytesRemaining = rdlen;
      while (bytesRemaining > 0) {
        const uint8_t  *p = ptr;
        string          s;
        ptr = DecodeCharacterString(s, pkt, ptr, pktlen);
        bytesRemaining -= (s.size() + 1);
        _txt.push_back(s);
      }
      if ((ptr - origptr) != rdlen) {
        throw out_of_range("Dwn::Dns::RRDataTXT incorrect length");
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataTXT & txt)
    {
      if (os) {
        if (! txt._txt.empty()) {
          auto  it = txt._txt.begin();
          os << '"' << *it << '"';
          ++it;
          for ( ; it != txt._txt.end(); ++it) {
            os << " \"" << *it << '"';
          }
        }
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
