//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataA.cc 10133 $
// @(#) $Id: DwmDnsRRDataA.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataA.cc
//!  \brief Dwm::Dns::RRDataA class implementation
//---------------------------------------------------------------------------

extern "C" {
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
}

#include <cstring>
#include <sstream>
#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsRRDataA.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsRRDataA.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataA::RRDataA()
    {
      _inAddr.s_addr = INADDR_NONE;
    }
   
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataA::RRDataA(const in_addr & inAddr)
        : _inAddr(inAddr)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataA::operator == (const RRDataA & a) const
    {
      return (memcmp(&_inAddr, &a._inAddr, sizeof(_inAddr)) == 0);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const in_addr & RRDataA::InAddr() const
    {
      return _inAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const in_addr & RRDataA::InAddr(const in_addr & inAddr)
    {
      _inAddr = inAddr;
      return _inAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *
    RRDataA::Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen,
                    LabelPositions & lps) const
    {
      if (pkt && ptr && pktlen) {
        if ((ptr + sizeof(_inAddr.s_addr)) <= (pkt + pktlen)) {
          memcpy(ptr, &_inAddr.s_addr, sizeof(_inAddr.s_addr));
          ptr += sizeof(_inAddr.s_addr);
        }
        else {
          throw out_of_range("Dwm::Dns::RRDataA will not fit in packet");
        }
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataA::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                   uint16_t pktlen, uint16_t rdlen)
    {
      if (pkt && ptr && pktlen) {
        if (((ptr + sizeof(_inAddr.s_addr)) <= (pkt + pktlen))
            && (rdlen == sizeof(_inAddr.s_addr))) {
          memcpy(&_inAddr.s_addr, ptr, sizeof(_inAddr.s_addr));
          ptr += sizeof(_inAddr.s_addr);
        }
        else {
          ostringstream  oss;
          oss << "packet too short to contain Dwm::Dns::RRDataA: "
              << ((pkt + pktlen) - ptr)
              << " vs. " << sizeof(_inAddr.s_addr) << '\n';
          throw out_of_range(oss.str());
        }
      }
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataA & a)
    {
      if (os) {
        char  buf[INET_ADDRSTRLEN] = { 0 };
        inet_ntop(AF_INET, &a._inAddr, buf, INET_ADDRSTRLEN);
        os << buf;
      }
      return os;
    }
    
  }  // namespace Dns

}  // namespace Dwm
