//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsLabel.cc 10133 $
// @(#) $Id: DwmDnsLabel.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2000, 2016, 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsLabel.cc
//!  \brief Dwm::Dns::Label class implementation
//---------------------------------------------------------------------------

#include <stdexcept>

#include "DwmSvnTag.hh"
#include "DwmDnsLabel.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/tags/DwmDns-0.1.0/classes/src/DwmDnsLabel.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Label::Label(const string & label)
        : _value(label)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Label::operator string () const
    {
      return _value;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *Label::Encode(uint8_t *pkt, uint8_t *ptr, uint16_t pktlen) const
    {
      if (pkt && ptr && pktlen) {
        const uint8_t  *endptr = ptr + 1 + _value.size();
        if (endptr <= (pkt + pktlen)) {
          *ptr++ = _value.size();
          if (! _value.empty()) {
            _value.copy((char *)ptr, _value.size());
            ptr += _value.size();
          }
        }
        else {
          throw out_of_range("Dwm::Dns::Label will not fit in packet");
        }
      }
      return ptr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *Label::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                 uint16_t pktlen)
    {
      _value.clear();
      if (pkt && ptr && pktlen) {
        if (ptr <= (pkt + pktlen)) {
          uint8_t  len = *ptr++ & 0x3f;
          if ((ptr + len) <= (pkt + pktlen)) {
            _value.assign((const char *)ptr, len);
            ptr += len;
          }
          else {
            throw out_of_range("packet too short to contain Dwm::Dns::Label");
          }
        }
        else {
          throw out_of_range("packet too short to contain Dwm::Dns::Label");
        }
      }
      return ptr;
    }
    
    
  }  // namespace Dns

}  // namespace Dwm
